import express from 'express';
import { Auth } from '../middleware/user.js';
const router = express.Router();

import {
    createRoom, fetchAllRooms, fetchRoomByFilter, removeRoom, summarizeChat
} from '../controllers/room.js';

router.post('/', Auth, createRoom);
router.get('/', Auth, fetchAllRooms);
router.post('/filter', Auth, fetchRoomByFilter);
router.post('/summarize', Auth, summarizeChat);
router.patch('/remove', Auth, removeRoom);

export default router;