import express from "express";
const router = express.Router();

import { Auth } from "../middleware/user.js";

import {
    askFromOpenAi,
    askFromParticipants,
    clearMessages,
    downloadMessages,
    fetchAllMessages,
    starMessage
} from "../controllers/message.js";

router.post("/", Auth, askFromOpenAi);
router.post("/participants/", Auth, askFromParticipants);
router.get("/:roomId", Auth, fetchAllMessages);
router.patch("/remove", Auth, clearMessages);
router.post('/download', Auth, downloadMessages);
router.post('/star', Auth, starMessage);

export default router;