import express from "express";

const router = express.Router();

import {AdminAuth, Auth} from "../middleware/user.js";
import {
    addBot, addParticipant,
    deleteBanWord, deleteBot, deleteParticipant,
    fetchAllBanWords,
    fetchAllUsers, getAllParticipants, getBots, getParticipants,
    removeUser,
    updateBanWord, updateParticipant,
    updateUser,
    addCoin, getCoins, deleteCoin
} from "../controllers/admin.js";

router.post("/banned-words", AdminAuth, updateBanWord);
router.get("/banned-words", Auth, fetchAllBanWords);

router.patch("/banned-words/remove", AdminAuth, deleteBanWord);

//user CRUD
router.post("/users", AdminAuth, updateUser);
router.get("/users", AdminAuth, fetchAllUsers);
router.patch("/users/:id", AdminAuth, removeUser);

//bot CRUD
router.post("/add-bot", AdminAuth, addBot);
router.get("/get-bots", Auth, getBots);
router.patch("/delete-bot/:id", AdminAuth, deleteBot);

//COIN CRUD
router.post("/add-coin", AdminAuth, addCoin);
router.get("/get-coins", Auth, getCoins);
router.patch("/delete-coin/:id", AdminAuth, deleteCoin);

//PARTICIPANT CRUD
router.post("/participants", AdminAuth, addParticipant);
router.post("/participants/:id", AdminAuth, updateParticipant);
router.get("/participants/:id", Auth, getParticipants);
router.get("/participants/", Auth, getAllParticipants);
router.patch("/participants/:id", AdminAuth, deleteParticipant);

export default router;