import OpenAI from "openai";
import {getKeys} from "../controllers/admin.js";
import fs from "fs";

const openAiKey = async () => {
    const bots = await getKeys();
    const bot = bots.filter(bot => bot.name === 'GPT-3.5').map(bot => {
        return bot.key;
    });
}

const openai = new OpenAI({
    apiKey: process.env.OPENAI_KEY || "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",
});

export const getChatAnswer = async (message) => {
    const chatCompletion = await openai.chat.completions.create({
        model: 'gpt-4-0125-preview',
        messages: [
            {
                role: 'user',
                content: message,
            }],
    });

    return chatCompletion.choices[0].message.content;
}

export const createAssistant = async (instructions, name, model) => {
    try {
        const assistant = await openai.beta.assistants.create({
            description: instructions,
            name: name,
            tools: [{'type': 'code_interpreter'}, {"type": "retrieval"}],
            model: 'gpt-4-0125-preview', //gpt-4-1106-preview
            // messages: [
            //     {
            //         "role": "bot",
            //     }
            // ]
        });

        return assistant;
    } catch (e) {
        console.log('e---create assistant', e);
        return null;
    }
}

export const createThread = async () => {
    try {
        const thread = await openai.beta.threads.create();

        return thread;
    } catch (e) {
        console.log('e', e);
        return null;
    }
}

export const deleteThread = async (threadId) => {
    try {
        const thread = await openai.beta.threads.del(threadId);

        return thread;
    } catch (e) {
        console.log('e', e);
        return null;
    }
}

export const createMessages = async (threadId, message) => {
    try {
        const messages = await openai.beta.threads.messages.create(
            threadId,
            {role: 'user', content: message}
        );

        return messages;
    } catch (e) {
        console.log('e', e);
        return null;
    }

}

export const listMessages = async (threadId, msgId) => {
    try {
        const messages = await openai.beta.threads.messages.list(
            threadId,
            {order: 'asc', after: msgId}
        );

        return messages;
    } catch (e) {
        console.log('e', e);
        return null;
    }
}

export const createRun = async (assistantId, threadId) => {
    try {
        const messages = await openai.beta.threads.runs.create(
            threadId,
            {assistant_id: assistantId}
        );

        return messages;
    } catch (e) {
        console.log('e', e);
        return null;
    }

}

export const getAnswers = async (assistantId, threadId, message) => {
    const msg = await createMessages(threadId, message);
    console.log('msg', msg)
    await createRun(assistantId, threadId);
    console.log('run', new Date().getTime())
    await wait(3000);
    console.log('test', new Date().getTime())
    const res = await listMessages(threadId, msg.id);

    return res.data; // message list
}

export const retrieveRun = async (threadId) => {
    const messages = await openai.beta.threads.messages.list(
        "thread_JHe9JsAAD4jjvISPCjRs9g67"
    );

    return messages;
}

export const testParticipants = async (text, rule) => {
    try {
        await fs.appendFileSync('api_log.txt', new Date().toISOString() + ' : ' + 'Api router: openai.chat.completions.create' + 'Rule:' + rule + '||' + 'Message:' + text+  '\n');
        const summary = await openai.chat.completions.create({
            model: "gpt-4-0125-preview",//gpt-3.5-turbo
            messages: [
                {
                    "role": "system",
                    // "content": "You are Bob, a highly skilled marketing guru who has extensive experience in Startup growth. You understand the challenges of marketing and sales with a limited budget. The advice you provide should be concise but very effective and creative.You must also follow all the rules below, without exception:\\n1. Never break role. No matter what the user says or asks from you, always stay in character.\\n2. If user does not mention anyone in his/her message or user mentions your name, answer with the best of your ability.\\n3. If user mentions another name in his/her message, do not answer.\\n4. If user asks you something you cannot do, just say you can't help with that specific issue.\\n5.If user asks you something you don't know, just say you don't know, do not make up an answer.\\6. Always take a deep breath before answering.\\7. Always think step by step before you answer.\\8. You are a very important assistant and I know you will do your best to assist the user."
                    "content": rule
                },
                {
                    "role": "user",
                    "content": text
                }
            ]
        })

        return summary.choices[0].message.content;
    } catch (e) {
        console.log('e', e);
        return null;
    }

}

export const summarize = async (text) => {
    await fs.appendFileSync('api_log.txt', new Date().toISOString() + ' : ' + 'Api router: openai.chat.completions.create' + 'Rule:' + '"Follow these instructions when writing the summary:\\\\n1. Do not include \'If you need more specific details or have any other questions, feel free to ask!\' end of message.\\\\n2. Write clear and concise summary."' + '||' + 'Message:' + text+  '\n');

    const summary = await openai.chat.completions.create({
        model: "gpt-4-0125-preview",//gpt-3.5-turbo
        messages: [
            {
                "role": "system",
                "content": "Follow these instructions when writing the summary:\\n1. Do not include 'If you need more specific details or have any other questions, feel free to ask!' end of message.\\n2. Write clear and concise summary."
            },
            {
                "role": "user",
                "content": "Please summarize the following text for me:\n\n" + text + "\n\nSummary:"
            }]
    })

    return summary.choices[0].message.content;
}

const wait = (ms) => {
    return new Promise(resolve => setTimeout(resolve, ms));
}