import mongoose from "mongoose";

const mongoDBConnect = async () => {
    try {
        await mongoose.connect(process.env.MONGO_URI, {
            useUnifiedTopology: true,
            useNewUrlParser: true,
        });
        console.log("MongoDB - Connected");
    } catch (error) {
        console.log("Error - MongoDB Connection " + error);
    }
}
export default mongoDBConnect;