import mongoose from "mongoose";

const roomSchema = new mongoose.Schema(
    {
        photo: {
            type: String,
            default: 'https://cdn-icons-png.flaticon.com/512/9790/9790561.png',
        },
        roomName: {
            type: String,
        },
        isGroup: {
            type: Boolean,
            default: true,
        },
        bots: [
            {
                type: mongoose.Schema.Types.ObjectId,
                ref: 'Bot',
            }
        ],
        participants: [
            {
                type: mongoose.Schema.Types.ObjectId,
                ref: 'Participant',
            }
        ],
        gpt: {
            type: Object,
            default: {
                assistantId: '',
                threadId: '',
            }
        },
        users: [
            {
                type: mongoose.Schema.Types.ObjectId,
                ref: 'User',
            },
        ],
        latestMessage: {
            type: mongoose.Schema.Types.ObjectId,
            ref: 'Message',
        },
        groupAdmin: {
            type: mongoose.Schema.Types.ObjectId,
            ref: 'User',
        },
        context: {
            type: String,
            default: '',
        }
    },
    {
        timestamps: true,
    }
);

const roomModel = mongoose.model('Room', roomSchema);
export default roomModel;