import mongoose from "mongoose";

const participantSchema = new mongoose.Schema(
    {
        name: {
            type: String,
            required: true,
        },
        role: {
            type: String,
            required: true,
        },
        profilePic: {
            type: String,
            default: 'https://icon-library.com/images/anonymous-avatar-icon/anonymous-avatar-icon-25.jpg'
        },
        functions: {
            type: String,
            required: true,
        },
        description: {
            type: String,
            default: ""
        }
    }
);

const participantModel = mongoose.model('Participant', participantSchema);

export default participantModel;