import mongoose from "mongoose";

const messageSchema = new mongoose.Schema(
    {
        sender: {
            type: mongoose.Schema.Types.ObjectId,
            ref: "User",
        },
        message: {
            type: String,
            trim: true,
        },
        summarized: {
            type: String,
            trim: true,
        },
        type: {
            type: String,
            default: "ask-user",
        },
        star: {
            type: Boolean,
            default: false,
        },
        roomId: {
            type: mongoose.Schema.Types.ObjectId,
            ref: "Room",
        }
    },
    {
        timestamps: true,
    }
);

const messageModel = mongoose.model("Message", messageSchema);
export default messageModel;