import mongoose from "mongoose";

const botSchema = new mongoose.Schema(
    {
        name: {
            type: String,
            required: true,
        },
        endpoint: {
            type: String,
            required: true,
        },
        key: {
            type: String,
            required: true,
        },
        logo: {
            type: String,
            default: 'https://icon-library.com/images/anonymous-avatar-icon/anonymous-avatar-icon-25.jpg'
        },
        description: {
            type: String,
            required: true,
        }
    }
);

const botModel = mongoose.model('Bot', botSchema);
export default botModel;