import express from 'express';
import mongoose from "mongoose";
import dotenv from 'dotenv/config';
import mongoDBConnect from './mongoDB/connection.js';
import bodyParser from 'body-parser';
import cors from 'cors';
import userRoutes from './routes/user.js';
import roomRoutes from './routes/room.js';
import messageRoutes from './routes/message.js';
import adminRoutes from './routes/admin.js';
import assistantRoutes from "./routes/assistant.js";
import subscriptionRoutes from "./routes/subscription.js";
import stripeRoutes from "./routes/stripe.js";


import path from 'path';

const app = express();

const corsConfig = {
    origin: '*',
    credentials: true,
    methods: 'GET, POST, PATCH, DELETE',
    allowedHeaders:
        'Origin, X-Requested-With, Content-Type, Accept, Authorization',
};

const PORT = process.env.PORT || 8000;


app.use(bodyParser.json());
app.use(bodyParser.urlencoded({ extended: true }));
app.use(cors(corsConfig));
// router config
app.use('/', userRoutes);
app.use('/api/room', roomRoutes);
app.use('/api/message', messageRoutes);
app.use('/api/admin', adminRoutes);
app.use('/api/assistant', assistantRoutes);
app.use('/api/subscription', subscriptionRoutes);
app.use('/api/stripe', stripeRoutes);

// front end inserting
app.use(express.static(path.join('client/build')));
app.use('*', (req, res) => res.sendFile(path.resolve('client/build/index.html')));

mongoose.set('strictQuery', false);
mongoDBConnect();

app.listen(PORT || 8000, () => {
    console.log(`Server Listening at PORT - ${PORT}`);
});
