import user from '../models/userModel.js';
import bcrypt from 'bcryptjs';
import {OAuth2Client} from 'google-auth-library';

export const register = async (req, res) => {
    const {username, email, password} = req.body;
    try {
        const existingUser = await user.findOne({email});
        if (existingUser)
            return res.status(400).json({error: 'User already Exits'});
        const newUser = new user({email, password, name: username});
        console.log(newUser);
        const token = await newUser.generateAuthToken();
        await newUser.save();

        res.status(200).json({message: 'success', token: token});
    } catch (error) {
        console.log('Error in register ' + error);
        res.status(500).json({message: error});
    }
};
export const login = async (req, res) => {
    const {email, password} = req.body;
    console.log(email, password);
    try {
        const valid = await user.findOne({email});
        if (!valid) res.status(200).json({message: 'User don\'t exist'});
        const validPassword = await bcrypt.compare(password, valid.password);
        if (!validPassword) {
            res.status(200).json({message: 'Invalid Credentials'});
        } else {
            const token = await valid.generateAuthToken();
            const username = valid.name;
            const pic = valid.profilePic;
            await valid.save();
            res.cookie('userToken', token, {
                httpOnly: true,
                maxAge: 24 * 60 * 60 * 1000,
            });
            res.status(200).json({message: 'success', token: token, email: email, username: username, pic: pic, coins: 0});
            console.log('login success');
        }
    } catch (error) {
        res.status(500);
        console.log(error);
    }
};
export const validUser = async (req, res) => {
    try {
        const validuser = await user
            .findOne({_id: req.rootUserId})
            .select('-password');
        if (!validuser) res.json({message: 'user is not valid'});
        res.status(201).json({
            user: validuser,
            token: req.token,
        });
    } catch (error) {
        res.status(500);
        console.log(error);
    }
};
export const validAdmin = async (req, res) => {
    try {
        const validAdmin = await user
            .findOne({_id: req.rootUserId})
            .select('-password');
        if (!validAdmin || !validAdmin.isAdmin) res.json({message: 'user is not admin'});
        res.status(201).json({
            user: validAdmin,
            token: req.token,
        });
    } catch (error) {
        res.status(500);
        console.log(error);
    }
}
export const googleAuth = async (req, res) => {
    try {
        const {tokenId} = req.body;
        const client = new OAuth2Client(process.env.JWT_CLIENT_ID);
        // console.log('client id:' + process.env.JWT_CLIENT_ID);
        const verify = await client.verifyIdToken({
            idToken: tokenId,
            audience: process.env.JWT_CLIENT_ID,
        });
        const {email_verified, email, name, picture} = verify.payload;
        if (!email_verified) res.json({message: 'Email Not Verified'});
        const userExist = await user.findOne({email}).select('-password');
        if (userExist) {
            res.cookie('userToken', tokenId, {
                httpOnly: true,
                maxAge: 24 * 60 * 60 * 1000,
            });

            res.json({token: tokenId, user: userExist});
        } else {
            const password = email + process.env.JWT_CLIENT_ID;
            const newUser = await user({
                name: name,
                profilePic: picture,
                password,
                email,
            });
            await newUser.save();
            res.cookie('userToken', tokenId, {
                httpOnly: true,
                maxAge: 24 * 60 * 60 * 1000,
            });

            res.json({message: 'User registered Successfully', token: tokenId});
        }
    } catch (error) {
        res.status(500);
        console.log('error in googleAuth backend' + error);
    }
};

export const logout = (req, res) => {
    req.rootUser.tokens = req.rootUser.tokens.filter((e) => e.token != req.token);
};

export const searchUsers = async (req, res) => {
    // const { search } = req.query;
    const search = req.query.search
        ? {
            $or: [
                {name: {$regex: req.query.search, $options: 'i'}},
                {email: {$regex: req.query.search, $options: 'i'}},
            ],
        }
        : {};

    const users = await user.find(search).find({_id: {$ne: req.rootUserId}});
    res.send(users);
};
export const getUserById = async (req, res) => {
    const {id} = req.params;
    try {
        const selectedUser = await user.findOne({_id: id}).select('-password');
        console.log('user', selectedUser)
        res.status(200).json(selectedUser);
    } catch (error) {
        res.status(500);
    }
};
export const updateInfo = async (req, res) => {
    const {id} = req.params;
    const {bio, name} = req.body;
    try {
        const updatedUser = await user.findByIdAndUpdate(id, {name, bio});
        res.status(200).json({message: 'success', data: updatedUser});
    } catch (error) {
        res.status(500).json({message: 'error'});
    }

};
export const resetPassword = async (req, res) => {
    const {email} = req.params;
    try {
        const existingUser = await user.findOne({email});
        if (!existingUser) res.status(400).json({message: 'User don\'t exist'});
        const token = await existingUser.generateAuthToken();

        res.status(200).json({message: 'success', token: token});
    } catch (e) {
        res.status(500).json({message: 'user not found'});
    }
}