import Message from "../models/messageModel.js";
import Room from "../models/roomModel.js";
import User from "../models/userModel.js";

import {
  getAnswers,
  summarize,
  testParticipants,
} from "../providers/openai.js";

import fs from "fs";

export const askFromOpenAi = async (req, res) => {
  const { message, roomId, type, quotes } = req.body;
  try {
    let msg = await Message.create({
      sender: req.rootUserId,
      message,
      summarized: message,
      roomId,
      type: type,
    }); //ask-user, ask-gpt, ask-poe, ask-bard, etc
    msg = await (
      await msg.populate("sender", "name profilePic email")
    ).populate({
      path: "roomId",
      select: "roomName isGroup users",
      model: "Room",
      populate: {
        path: "users",
        select: "name email profilePic",
        model: "User",
      },
    });

    await Room.findByIdAndUpdate(roomId, {
      latestMessage: msg,
    });

    const room = await Room.findById(roomId);
    const assistantId = room.gpt.assistantId;
    const threadId = room.gpt.threadId;
    const answers = await getAnswers(assistantId, threadId, message);
    // for (let i = 0; i < answers.length; i++) {
    //     const summarized = await summarize(answers[i].content[0].text.value);
    //     if (answers[i].role === 'user') {
    //         await Message.create({
    //             sender: req.rootUserId,
    //             message: summarized,
    //             roomId,
    //             type: 'ask-user'
    //         });
    //     } else {
    //         await Message.create({
    //             sender: room.gpt.userId,
    //             message: summarized,
    //             roomId,
    //             type: 'answer-gpt'
    //         });
    //     }
    // }
    let answer = answers[answers.length - 1].content[0].text.value;
    console.log("answer", answer);
    // answer = await summarize(answer);
    let answerMsg = await Message.create({
      sender: room.gpt.userId,
      message: answer,
      summarized: answer,
      roomId,
      type: "answer-gpt",
    });
    answerMsg = await (
      await answerMsg.populate("sender", "name profilePic email")
    ).populate({
      path: "roomId",
      select: "roomName isGroup users",
      model: "Room",
      populate: {
        path: "users",
        select: "name email profilePic",
        model: "User",
      },
    });

    await Room.findByIdAndUpdate(roomId, {
      latestMessage: answerMsg,
    });

    res.send({
      status: "success",
      data: answerMsg,
    });
  } catch (e) {
    res.send({
      status: "error",
      message: e.message,
    });
  }
};

export const askFromParticipants = async (req, res) => {
  const { message, roomId, type, quotes, rule, participantName, order } =
    req.body;
  try {
    let msg;
    if (order === 0) {
      msg = await Message.create({
        sender: req.rootUserId,
        message,
        summarized: message,
        roomId,
        type: type,
      }); //ask-user, ask-gpt, ask-poe, ask-bard, etc
      msg = await (
        await msg.populate("sender", "name profilePic email")
      ).populate({
        path: "roomId",
        select: "roomName isGroup users participants",
        model: "Room",
        populate: {
          path: "users",
          select: "name email profilePic",
          model: "User",
        },
      });
    } else {
      msg = await Message.create({
        sender: req.rootUserId,
        message: "",
        summarized: "",
        roomId,
        type: "duplicated",
      }); //ask-user, ask-gpt, ask-poe, ask-bard, etc
      msg = await (
        await msg.populate("sender", "name profilePic email")
      ).populate({
        path: "roomId",
        select: "roomName isGroup users participants",
        model: "Room",
        populate: {
          path: "users",
          select: "name email profilePic",
          model: "User",
        },
      });
    }

    await Room.findByIdAndUpdate(roomId, {
      latestMessage: msg,
    });

    const room = await Room.findById(roomId);
    // const assistantId = room.gpt.assistantId;
    // const threadId = room.gpt.threadId;
    if (message) {
      console.log("message", message);

      if (!fs.existsSync("api_log.txt")) {
        fs.writeFileSync("api_log.txt", "");
      }
      if (message) {
        await fs.appendFileSync(
          "api_log.txt",
          new Date().toISOString() +
            " : question message : " +
            message +
            "\n rule: " +
            rule +
            "\n ======================\n"
        );
      }
      let answer = await testParticipants(message, rule);

      console.log("answer - -a-sd>>>", answer);
      // let answer = message.text.value;
      // answer = await summarize(answer);
      let answerMsg = await Message.create({
        sender: room.gpt.userId,
        message: answer,
        summarized: answer,
        roomId,
        type: participantName,
      });

      if (answer) {
        await fs.appendFileSync(
          "api_log.txt",
          new Date().toISOString() +
            "sender: " +
            room.gpt.userId +
            "type:" +
            participantName +
            " : answer : " +
            answer +
            "\n " +
            "\n +++++++++++++++++++++++++\n"
        );
      }

      answerMsg = await (
        await answerMsg.populate("sender", "name profilePic email")
      ).populate({
        path: "roomId",
        select: "roomName isGroup users",
        model: "Room",
        populate: {
          path: "users",
          select: "name email profilePic",
          model: "User",
        },
      });

      //calculate token of subscription
      const dev = await User.findById(req.rootUserId);
      if (dev) {
        dev.tokens = dev.tokens - 1;
        await dev.save();
      }

      await Room.findByIdAndUpdate(roomId, {
        latestMessage: answerMsg,
      });
    }

    res.send({
      status: "success",
      data: "success",
    });
  } catch (e) {
    res.send({
      status: "error",
      message: e.message,
    });
  }
};

export const fetchAllMessages = async (req, res) => {
  const { roomId } = req.params;
  try {
    let messages = await Message.find({ roomId })
      .populate({
        path: "sender",
        model: "User",
        select: "name profilePic email",
      })
      .populate({
        path: "roomId",
        model: "Room",
      });

    res.send({
      status: "success",
      data: messages,
    });
  } catch (e) {
    res.send({
      status: "error",
      message: e.message,
    });
  }
};

export const clearMessages = async (req, res) => {
  const { roomId } = req.body;
  try {
    await Message.deleteMany({ roomId });
    res.send({
      status: "success",
      message: "Messages deleted successfully",
    });
  } catch (e) {
    res.send({
      status: "error",
      message: e.message,
    });
  }
};

export const downloadMessages = async (req, res) => {
  const { roomId } = req.body;
  try {
    const messages = await Message.find({ roomId })
      .populate({
        path: "sender",
        model: "User",
        select: "name profilePic email",
      })
      .populate({
        path: "roomId",
        model: "Room",
      });

    // fs.writeFile(`../downloads/${roomId}.txt`, JSON.stringify(messages), {flag: 'w+'},(err) => {
    //     if (err) throw err;
    //     console.log('File saved!');
    // });

    res.send({
      status: "success",
      data: messages,
    });
  } catch (e) {
    res.send({
      status: "error",
      message: e.message,
    });
  }
};

export const starMessage = async (req, res) => {
  const { messageId } = req.body;
  try {
    const message = await Message.findById(messageId);
    message.star = !message.star;
    await message.save();
    res.send({
      status: "success",
      message: "Message starred successfully",
    });
  } catch (e) {
    res.send({
      status: "error",
      message: e.message,
    });
  }
};
