import {createAssistant, createMessages, createRun, createThread, retrieveRun} from "../providers/openai.js";

export const assistants = async (req, res) => {
    const instructions = "you are my the best assistant";
    const name = "assistant";
    const model = "gpt-3.5-turbo-1106";
   try {
       const assistant = await createAssistant(instructions, name, model);

       console.log('assistant', assistant);

         res.send({
                status: 'success',
                data: assistant,
         });
   } catch (e) {
         res.send({
              status: 'error',
              message: e.message,
         });
   }
}

export const threads = async (req, res) => {
    const {assistantId, instructions} = req.body;
    try {
        const thread = await createThread(assistantId, instructions);

        res.send({
            status: 'success',
            data: thread,
        });
    } catch (e) {
        res.send({
            status: 'error',
            message: e.message,
        });
    }
}

export const createMessage = async (req, res) => {
    const {assistantId, threadId, message} = req.body;
    try {
        const messages = await createMessages(assistantId, threadId, message);

        res.send({
            status: 'success',
            data: messages,
        });
    } catch (e) {
        console.log('e', e)
        res.send({
            status: 'error',
            message: e.message,
        });
    }
}

export const getAnswer = async (req, res) => {
    const {assistantId, threadId, message} = req.body;
    try {
        const messages = await createRun(assistantId, threadId, message);

        res.send({
            status: 'success',
            data: messages,
        });
    } catch (e) {
        res.send({
            status: 'error',
            message: e.message,
        });
    }
}

export const getChatAnswer = async (req, res) => {
    const {assistantId, threadId, message} = req.body;
    try {
        const messages = await retrieveRun(assistantId, threadId, message);
        res.send({
            status: 'success',
            data: messages,
        });
    } catch (e) {
        res.send({
            status: 'error',
            message: e.message,
        });
    }
}