import BanWord from "../models/banWordModel.js";
import User from "../models/userModel.js";
import Bot from "../models/botModel.js";
import Coin from "../models/coinModel.js";
import Participant from "../models/participantModel.js";
import Room from "../models/roomModel.js";

const addBanWord = async (req, res) => {
  const { words } = req.body;
  try {
    const banWord = await BanWord.create({ words });
    res.send({
      status: "success",
      data: banWord,
    });
  } catch (e) {
    res.send({
      status: "error",
      message: e.message,
    });
  }
};

export const fetchAllBanWords = async (req, res) => {
  try {
    const banWords = await BanWord.find();
    res.send({
      status: "success",
      data: banWords,
    });
  } catch (e) {
    console.log(e.message);
    res.send({
      status: "error",
      message: e.message,
    });
  }
};

export const deleteBanWord = async (req, res) => {
  try {
    const { id } = req.params;

    await BanWord.findByIdAndDelete(id);
    res.send({
      status: "success",
      data: null,
    });
  } catch (e) {
    res.send({
      status: "error",
      message: e.message,
    });
  }
};

export const updateBanWord = async (req, res) => {
  try {
    const { words } = req.body;
    const banWord = await BanWord.find();
    console.log(banWord);
    if (banWord.length === 0) {
      await addBanWord(req, res);
    } else {
      const id = banWord[0]._id;
      const newWords = await BanWord.findByIdAndUpdate(id, { words });
      res.send({
        status: "success",
        data: newWords,
      });
    }
  } catch (e) {
    res.send({
      status: "error",
      message: e.message,
    });
  }
};

/// user crud
export const fetchAllUsers = async (req, res) => {
  try {
    const users = await User.find();
    res.send({
      status: "success",
      data: users,
    });
  } catch (e) {
    res.send({
      status: "error",
      message: e.message,
    });
  }
};

export const removeUser = async (req, res) => {
  try {
    const { id } = req.params;
    await User.findByIdAndDelete(id);
    res.send({
      status: "success",
      data: null,
    });
  } catch (e) {
    res.send({
      status: "error",
      message: e.message,
    });
  }
};

export const updateUser = async (req, res) => {
  try {
    const { name, email, isAdmin } = req.body;
    const user = await User.find({ email });
    if (user.length === 0) {
      res.send({
        status: "error",
        message: "User not found",
      });
    } else {
      const id = user[0]._id;
      const newUser = await User.findByIdAndUpdate(id, {
        name,
        email,
        isAdmin,
      });
      res.send({
        status: "success",
        data: newUser,
      });
    }
  } catch (e) {
    res.send({
      status: "error",
      message: e.message,
    });
  }
};

//// bot config crud

export const addBot = async (req, res) => {
  try {
    const { name, endpoint, key, description } = req.body;

    const checkBot = await Bot.find({ endpoint });

    if (checkBot.length > 0) {
      const update = await Bot.findByIdAndUpdate(checkBot[0]._id, {
        endpoint,
        key,
        description,
      });
      res.status(200).json({
        status: "success",
        message: name + "Bot updated",
      });
    } else {
      const bot = await Bot.create({ name, endpoint, key, description });
      res.status(200).json({
        status: "success",
        message: "New Bot added",
      });
    }
  } catch (error) {
    res.status(500).json({
      status: "error",
      message: "Something went wrong",
    });
    console.log(error);
  }
};

export const getBots = async (req, res) => {
  try {
    let bots = await Bot.find();
    bots.map((bot) => {
      bot.key = "";
    });

    res.status(200).json({
      status: "success",
      data: bots,
    });
  } catch (error) {
    res.status(500).json({
      status: "error",
      message: "Something went wrong",
    });
    console.log(error);
  }
};

//coin config crud
export const addCoin = async (req, res) => {
  try {
    const { name, rate } = req.body;

    const checkCoin = await Coin.find({ name });

    if (checkCoin.length > 0) {
      const update = await Coin.findByIdAndUpdate(checkCoin[0]._id, { rate });
      res.status(200).json({
        status: "success",
        message: name + "Coin updated",
      });
    } else {
      const coin = await Coin.create({ name, rate });
      res.status(200).json({
        status: "success",
        message: "New Coin added",
      });
    }
  } catch (error) {
    res.status(500).json({
      status: "error",
      message: "Something went wrong",
    });
    console.log(error);
  }
};

export const getCoins = async (req, res) => {
  try {
    let coins = await Coin.find();

    res.status(200).json({
      status: "success",
      data: coins,
    });
  } catch (error) {
    res.status(500).json({
      status: "error",
      message: "Something went wrong",
    });
    console.log(error);
  }
};

export const deleteCoin = async (req, res) => {
  try {
    const { id } = req.params;

    await Coin.findByIdAndDelete(id);
    res.status(200).json({
      status: "success",
      message: "Coin deleted",
    });
  } catch (error) {
    res.status(500).json({
      status: "error",
      message: "Something went wrong",
    });
    console.log(error);
  }
};



export const getKeys = async () => {
  try {
    let bots = await Bot.find();

    return bots;
  } catch (error) {
    console.log(error);
  }
};

export const deleteBot = async (req, res) => {
  try {
    const { id } = req.params;

    await Bot.findByIdAndDelete(id);
    res.status(200).json({
      status: "success",
      message: "Bot deleted",
    });
  } catch (error) {
    res.status(500).json({
      status: "error",
      message: "Something went wrong",
    });
    console.log(error);
  }
};

export const addParticipant = async (req, res) => {
  try {
    const { name, role, functions, description } = req.body;

    const participant = await Participant.create({
      name,
      role,
      functions,
      description,
    });

    res.status(200).json({
      status: "success",
      message: "Participant added",
    });
  } catch (e) {
    res.send({
      status: "error",
      message: e.message,
    });
  }
};

export const updateParticipant = async (req, res) => {
  try {
    const { name, role, functions, description } = req.body;
    const { id } = req.params;

    const participant = await Participant.find({ _id: id });
    if (participant.length === 0) {
      res.send({
        status: "error",
        message: "Participant not found",
      });
    } else {
      const newParticipant = await Participant.findByIdAndUpdate(id, {
        name,
        role,
        functions,
        description,
      });
      res.send({
        status: "success",
        message: "Participant updated",
      });
    }
  } catch (e) {
    res.send({
      status: "error",
      message: e.message,
    });
  }
};

export const getAllParticipants = async (req, res) => {
  try {
    const participants = await Participant.find();
    res.send({
      status: "success",
      data: participants,
    });
  } catch (e) {
    res.send({
      status: "error",
      message: e.message,
    });
  }
};
export const getParticipants = async (req, res) => {
  try {
    const { id } = req.params;
    const room = await Room.find({ _id: id });
    const participants = room[0].participants;

    let participantsList = [];
    for (let i = 0; i < participants.length; i++) {
      const participant = await Participant.find({ _id: participants[i] });
      participantsList.push(participant);
    }
    res.status(200).json({
      status: "success",
      data: participantsList,
    });
  } catch (e) {
    console.log(e);
    res.send({
      status: "error",
      message: e.message,
    });
  }
};

export const deleteParticipant = async (req, res) => {
  try {
    const { id } = req.params;

    await Participant.findByIdAndDelete(id);
    res.status(200).json({
      status: "success",
      message: "Participant deleted",
    });
  } catch (e) {
    res.send({
      status: "error",
      message: e.message,
    });
  }
};
